-- # Activité 7

-- T_ Ecrivez une fonction qui retourne le nom de la phase actuelle d’un concours (/ édition) dont on passe l’identifiant en paramètre (ex : « à venir », « inscriptions », « sélection », « finale », « terminé »).
-- * Phases prévues : à venir (V) / inscriptions (I) / sélection (S) / finale (F) / terminé (T)
DELIMITER //
CREATE FUNCTION donnerPhaseConcours(concId INT) RETURNS TEXT
BEGIN
    SET @conc_date_debut = (SELECT conc_date_debut FROM t_concours_conc WHERE conc_idConcours = concId);
    SET @conc_date_selection = (SELECT conc_date_debut_selection FROM t_concours_conc WHERE conc_idConcours = concId);
    SET @conc_date_finale = (SELECT conc_date_debut_finale FROM t_concours_conc WHERE conc_idConcours = concId);
    SET @conc_date_fin = (SELECT conc_date_fin FROM t_concours_conc WHERE conc_idConcours = concId);
    
    IF CURRENT_DATE() < @conc_date_debut THEN
        RETURN "V";
    ELSEIF CURRENT_DATE() >= @conc_date_debut AND CURRENT_DATE() < @conc_date_selection THEN
        RETURN "I";
    ELSEIF CURRENT_DATE() >= @conc_date_selection AND CURRENT_DATE() < @conc_date_finale THEN
        RETURN "S";
    ELSEIF CURRENT_DATE() >= @conc_date_finale AND CURRENT_DATE() < @conc_date_fin THEN
        RETURN "F";
    ELSEIF CURRENT_DATE() >= @conc_date_fin THEN
        RETURN "T";
    ELSE
        RETURN "E"; -- = Erreur
    END IF;
END;
// ;


-- T_ Testez cette fonction.




UPDATE `t_concours_conc` SET `conc_date_debut`=DATE_SUB(CURRENT_DATE(), INTERVAL 5 DAY) WHERE `conc_idConcours` = 1;
UPDATE `t_concours_conc` SET `conc_date_debut`=DATE_SUB(CURRENT_DATE(), INTERVAL 4 DAY) WHERE `conc_idConcours` = 2;
UPDATE `t_concours_conc` SET `conc_date_debut`=DATE_SUB(CURRENT_DATE(), INTERVAL 3 DAY) WHERE `conc_idConcours` = 3;
UPDATE `t_concours_conc` SET `conc_date_debut`=DATE_SUB(CURRENT_DATE(), INTERVAL 2 DAY) WHERE `conc_idConcours` = 4;
UPDATE `t_concours_conc` SET `conc_date_debut`=DATE_SUB(CURRENT_DATE(), INTERVAL 1 DAY) WHERE `conc_idConcours` = 5;
UPDATE `t_concours_conc` SET `conc_date_debut`=DATE_SUB(CURRENT_DATE(), INTERVAL 0 DAY) WHERE `conc_idConcours` = 6;
UPDATE `t_concours_conc` SET `conc_date_debut`=DATE_ADD(CURRENT_DATE(), INTERVAL 1 DAY) WHERE `conc_idConcours` = 7;

UPDATE `t_concours_conc` 
SET `conc_date_debut_selection`=DATE_ADD(`conc_date_debut`, INTERVAL 2 DAY),
    `conc_date_debut_finale`=DATE_ADD(`conc_date_debut`, INTERVAL 3 DAY),
    `conc_date_fin`=DATE_ADD(`conc_date_debut`, INTERVAL 4 DAY);
    
SELECT *, donnerPhaseConcours(`conc_idConcours`) FROM `t_concours_conc`;




INSERT INTO `t_concours_conc`(`conc_nomConcours`, `conc_date_debut`, `date_debut_selection`, `date_debut_finale`, `conc_date_fin`, `conc_description`, `cpt_pseudo`, `conc_phase`) VALUES ("Concours de bloc.",'2023-03-03','2023-03-05','2023-03-06','2023-03-07','Concours de blocs de Brest','f.martin','I')